    function hideLoading() {
            document.getElementById('iframeLoading').style.display = 'none';
            document.getElementById('termsIframe').style.display = 'block';
        }
        
        function acceptTerms() {
            // Check the terms checkbox
            document.getElementById('agreeTerms').checked = true;
            
            // Close the modal
            const modal = bootstrap.Modal.getInstance(document.getElementById('termsModal'));
            modal.hide();
            
            // Optional: Show a success message
            showToast('Terms accepted successfully!');
        }
        
        function showToast(message) {
            // Create a simple toast notification
            const toast = document.createElement('div');
            toast.className = 'toast align-items-center text-white bg-success border-0 position-fixed top-0 end-0 m-3';
            toast.style.zIndex = '9999';
            toast.innerHTML = `
                <div class="d-flex">
                    <div class="toast-body">
                        ${message}
                    </div>
                    <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"></button>
                </div>
            `;
            
            document.body.appendChild(toast);
            const bsToast = new bootstrap.Toast(toast);
            bsToast.show();
            
            // Remove the toast element after it's hidden
            toast.addEventListener('hidden.bs.toast', () => {
                document.body.removeChild(toast);
            });
        }
        
        // Reset iframe when modal is closed
        document.getElementById('termsModal').addEventListener('hidden.bs.modal', function() {
            document.getElementById('iframeLoading').style.display = 'flex';
            document.getElementById('termsIframe').style.display = 'none';
        });
        
        // Handle iframe loading errors
        document.getElementById('termsIframe').addEventListener('error', function() {
            document.getElementById('iframeLoading').innerHTML = `
                <div class="text-center">
                    <div class="text-danger mb-2">
                        <i class="bi bi-exclamation-triangle" style="font-size: 2rem;"></i>
                    </div>
                    <p class="text-muted">Unable to load Terms and Conditions.</p>
                    <p class="text-muted small">Please make sure the "terms.html" file exists.</p>
                </div>
            `;
        });
   